%------------------------------------------------------------------------------
% File     : NUM816^5 : TPTP v7.4.0. Bugfixed v5.2.0.
% Domain   : Number Theory (Induction on naturals)
% Problem  : TPS problem from IND-THMS
% Version  : Especial.
% English  :

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0817 [Bro09]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.44 v7.2.0, 0.38 v7.1.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.50 v6.3.0, 0.60 v6.2.0, 0.71 v6.1.0, 0.57 v5.5.0, 1.00 v5.2.0
% Syntax   : Number of formulae    :    7 (   0 unit;   4 type;   2 defn)
%            Number of atoms       :   31 (   5 equality;  13 variable)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   20 (   2   ~;   0   |;   2   &;  12   @)
%                                         (   0 <=>;   4  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    6 (   4   :;   0   =)
%            Number of variables   :    7 (   0 sgn;   5   !;   0   ?;   2   ^)
%                                         (   7   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : 
% Bugfixes : v5.2.0 - Added missing type declarations.
%------------------------------------------------------------------------------
thf(c0_type,type,(
    c0: $i )).

thf(cS_type,type,(
    cS: $i > $i )).

thf(cEVEN1_type,type,(
    cEVEN1: $i > $o )).

thf(cODD1_type,type,(
    cODD1: $i > $o )).

thf(cEVEN1_def,definition,
    ( cEVEN1
    = ( ^ [Xn: $i] :
        ! [Xp: $i > $o] :
          ( ( ( Xp @ c0 )
            & ! [Xx: $i] :
                ( ( Xp @ Xx )
               => ( Xp @ ( cS @ ( cS @ Xx ) ) ) ) )
         => ( Xp @ Xn ) ) ) )).

thf(cODD1_def,definition,
    ( cODD1
    = ( ^ [Xn: $i] :
          ~ ( cEVEN1 @ Xn ) ) )).

thf(cTHM406,conjecture,
    ( ( ! [Xu: $i] :
          ( ( cS @ Xu )
         != c0 )
      & ! [Xv: $i,Xw: $i] :
          ( ( ( cS @ Xv )
            = ( cS @ Xw ) )
         => ( Xv = Xw ) ) )
   => ( cODD1 @ ( cS @ c0 ) ) )).

%------------------------------------------------------------------------------
